/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.scope;

import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.IVWConfigActionListener;
import filenet.vw.toolkit.admin.VWConfigActionCommand;
import filenet.vw.toolkit.admin.VWConfigActionEvent;
import filenet.vw.toolkit.admin.VWConfigBaseNode;
import filenet.vw.toolkit.admin.VWConfigPerformer;
import filenet.vw.toolkit.admin.VWConfigRegionNode;
import filenet.vw.toolkit.admin.VWConfigRootNode;
import filenet.vw.toolkit.admin.VWConfigTreeCellRender;
import filenet.vw.toolkit.admin.VWConfigVWServiceNode;
import filenet.vw.toolkit.admin.scope.VWConfigScopeTree;
import filenet.vw.toolkit.admin.scope.VWScopeTreeMouseAndKeyListener;
import filenet.vw.toolkit.design.canvas.config.VWDesignerRootNode;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JScrollPane;
import javax.swing.ToolTipManager;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class VWConfigScopeViewPane
extends JScrollPane
implements TreeSelectionListener,
ActionListener,
IVWConfigActionListener {
    private VWConfigScopeTree m_scopeTree = null;
    private VWScopeTreeMouseAndKeyListener m_scopeTreeMouseAdapter = null;
    private VWConfigBaseNode m_focus = null;
    private EventListenerList m_listenerList = null;
    private VWConfigPerformer m_performer = null;
    private VWConfigRootNode m_root = null;
    private boolean m_refreshTree = false;

    public VWConfigScopeViewPane() {
        this.setDoubleBuffered(true);
        Dimension dim = VWStringUtils.stringToDimension("0,0");
        if (dim == null) {
            dim = new Dimension(0, 0);
        }
        this.setSize(dim.width, dim.height);
        this.m_listenerList = new EventListenerList();
        this.setHorizontalScrollBarPolicy(30);
        this.setVerticalScrollBarPolicy(20);
        this.setMinimumSize(new Dimension(0, 0));
        dim = VWStringUtils.stringToDimension("225,775");
        if (dim == null) {
            dim = new Dimension(200, 700);
        }
        this.setPreferredSize(dim);
    }

    public void init(VWConfigRootNode configRoot, VWConfigPerformer performer) {
        this.m_root = configRoot;
        this.m_focus = this.m_root;
        this.m_performer = performer;
        this.m_scopeTree = new VWConfigScopeTree(this.m_root, this.m_performer, this);
        if (configRoot instanceof VWDesignerRootNode) {
            this.m_scopeTree.setRootVisible(false);
        }
        this.m_scopeTree.getSelectionModel().setSelectionMode(1);
        this.m_scopeTree.addTreeSelectionListener(this);
        ToolTipManager.sharedInstance().registerComponent(this.m_scopeTree);
        this.m_scopeTree.setCellRenderer(new VWConfigTreeCellRender());
        this.m_scopeTreeMouseAdapter = new VWScopeTreeMouseAndKeyListener(this, this.m_scopeTree);
        this.m_scopeTree.addMouseListener(this.m_scopeTreeMouseAdapter);
        this.m_scopeTree.addKeyListener(this.m_scopeTreeMouseAdapter);
        this.displayAllRegions();
        this.getViewport().add(this.m_scopeTree);
    }

    public void addConfigActionListener(IVWConfigActionListener cal) {
        this.m_listenerList.add(IVWConfigActionListener.class, cal);
    }

    private void displayAllRegions() {
        int childCount = this.m_root.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            VWConfigVWServiceNode sNode = (VWConfigVWServiceNode)this.m_root.getChildAt(i);
            this.expandScopeTree(sNode);
        }
    }

    private void collapsePath(VWConfigBaseNode aNode) {
        this.m_refreshTree = true;
        TreePath treePath = new TreePath(aNode.getPath());
        this.m_scopeTree.collapsePath(treePath);
        this.m_refreshTree = false;
    }

    public void setSelectedPath(VWConfigBaseNode aNode) {
        this.m_refreshTree = true;
        TreePath treePath = new TreePath(aNode.getPath());
        this.m_scopeTree.setSelectionPath(treePath);
        this.m_refreshTree = false;
    }

    private void expandScopeTree(VWConfigBaseNode aNode) {
        this.m_refreshTree = true;
        TreePath treePath = new TreePath(aNode.getPath());
        this.m_scopeTree.setSelectionPath(treePath);
        this.m_scopeTree.expandPath(treePath);
        this.m_refreshTree = false;
    }

    public void valueChanged(TreeSelectionEvent event) {
        TreePath selPath = event.getPath();
        if (selPath == null) {
            return;
        }
        VWConfigBaseNode baseNode = (VWConfigBaseNode)selPath.getLastPathComponent();
        if (baseNode == null) {
            return;
        }
        this.setFocus(baseNode);
        if (!this.m_refreshTree) {
            this.fireConfigActionEvent(new VWConfigActionEvent(this, this.m_focus, 16));
        }
    }

    public void actionPerformed(ActionEvent event) {
        String actionCMD = event.getActionCommand();
        try {
            if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_LOGOFF) == 0) {
                if (this.m_performer.performLogoff(this.m_focus, true)) {
                    this.collapsePath(this.m_focus);
                    this.m_scopeTree.clearSelection();
                    this.setFocus((VWConfigBaseNode)this.m_focus.getParent());
                    this.fireConfigActionEvent(new VWConfigActionEvent(this, this.m_focus, 16));
                    this.m_scopeTree.refresh();
                }
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_LOGON) == 0) {
                if (this.m_performer.performLogon(this.m_focus)) {
                    this.expandScopeTree(this.m_focus);
                    this.fireConfigActionEvent(new VWConfigActionEvent(this, this.m_focus, 32));
                    this.m_scopeTree.refresh();
                }
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_APPSPACE_PROPERTIES) == 0) {
                this.m_performer.performAppSpaceProperty(this.m_focus);
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_COMMIT) == 0) {
                if (this.m_performer.performCommit(this.m_focus)) {
                    this.fireConfigActionEvent(new VWConfigActionEvent(this, this.m_focus, 32));
                    this.m_scopeTree.refresh();
                    this.m_scopeTree.requestFocus();
                }
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_COMPONENT_PROPERTIES) == 0) {
                this.m_performer.performComponentQueueProperty(this.m_focus);
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_COMPONENT_REGISTRATION) == 0) {
                this.m_performer.performComponentRegistration(this.m_focus);
                this.m_scopeTree.requestFocus();
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_CREATE_XLIFF_FILE) == 0) {
                this.m_performer.performCreateXliffFile(this.m_focus);
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_DELETE) == 0) {
                VWConfigBaseNode newFocusNode = this.m_performer.performDeleteItem(this.m_focus);
                if (newFocusNode != null) {
                    this.setFocus(newFocusNode);
                    this.fireConfigActionEvent(new VWConfigActionEvent(this, this.m_focus, 16));
                    this.fireConfigActionEvent(new VWConfigActionEvent(this, this.m_focus, 32));
                    this.m_scopeTree.refresh();
                }
                this.m_scopeTree.requestFocus();
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_DISCARD) == 0) {
                int ret;
                int nodeType = this.m_focus.getType();
                if (nodeType != 17 && nodeType != 18 && nodeType != 19) {
                    VWConfigRegionNode rNode = (VWConfigRegionNode)this.m_focus.findAncestorNode(19);
                    ret = this.m_performer.performDiscard(rNode, true, true);
                } else {
                    ret = this.m_performer.performDiscard(this.m_focus, true, true);
                }
                if (ret == 0) {
                    this.fireConfigActionEvent(new VWConfigActionEvent(this, this.m_focus, 32));
                    this.m_scopeTree.refresh();
                }
                this.m_scopeTree.requestFocus();
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_EVENTLOG_PROPERTIES) == 0) {
                this.m_performer.performEventLogProperty(this.m_focus);
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_EXPORT) == 0) {
                this.m_performer.performExport(this.m_focus);
                this.m_scopeTree.requestFocus();
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_IMPORT) == 0) {
                this.m_performer.performImport(this.m_focus);
                this.fireConfigActionEvent(new VWConfigActionEvent(this, this.m_focus, 32));
                this.m_scopeTree.refresh();
                this.m_scopeTree.requestFocus();
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_INITIALIZE_REGION) == 0) {
                this.m_performer.performInitRegion(this.m_focus);
                this.fireConfigActionEvent(new VWConfigActionEvent(this, this.m_focus, 32));
                this.expandScopeTree(this.m_focus);
                this.m_scopeTree.refresh();
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_NEW_APPSPACE) == 0) {
                this.m_performer.performNewAppSpace(this.m_focus);
                this.fireConfigActionEvent(new VWConfigActionEvent(this, this.m_focus, 32));
                this.m_scopeTree.refresh();
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_NEW_COMPONENT) == 0) {
                this.m_performer.performNewComponent(this.m_focus);
                this.fireConfigActionEvent(new VWConfigActionEvent(this, this.m_focus, 32));
                this.m_scopeTree.refresh();
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_NEW_EVENTLOG) == 0) {
                this.m_performer.performNewEventLog(this.m_focus);
                this.fireConfigActionEvent(new VWConfigActionEvent(this, this.m_focus, 32));
                this.m_scopeTree.refresh();
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_NEW_QUEUE) == 0) {
                this.m_performer.performNewQueue(this.m_focus);
                this.fireConfigActionEvent(new VWConfigActionEvent(this, this.m_focus, 32));
                this.m_scopeTree.refresh();
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_NEW_ROSTER) == 0) {
                this.m_performer.performNewRoster(this.m_focus);
                this.fireConfigActionEvent(new VWConfigActionEvent(this, this.m_focus, 32));
                this.m_scopeTree.refresh();
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_PUBLISH_UDDI) == 0) {
                this.m_performer.performPublishToUDDI(this.m_focus);
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_PUBLISH_WSRR) == 0) {
                this.m_performer.performPublishToWSRR(this.m_focus);
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_QUEUE_PROPERTIES) == 0) {
                this.m_performer.performQueueProperty(this.m_focus);
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_REGION_PROPERTIES) == 0) {
                this.m_performer.performRegionProperties(this.m_focus);
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_REMOVE_ALL_REGIONS) == 0) {
                if (this.m_performer.performRemoveAllRegions(this.m_focus)) {
                    this.fireConfigActionEvent(new VWConfigActionEvent(this, this.m_focus, 32));
                    VWConfigBaseNode aNode = null;
                    int childCount = this.m_focus.getChildCount();
                    for (int i = 0; i < childCount; ++i) {
                        aNode = (VWConfigBaseNode)this.m_focus.getChildAt(i);
                        this.collapsePath(aNode);
                    }
                }
                this.m_scopeTree.refresh();
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_REMOVE_REGION) == 0) {
                this.m_performer.performRemoveRegion(this.m_focus);
                this.fireConfigActionEvent(new VWConfigActionEvent(this, this.m_focus, 32));
                this.m_scopeTree.refresh();
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_REMOVE_WORKFLOW_DATABASE) == 0) {
                if (this.m_performer.performRemoveWorkflowDataBase(this.m_focus)) {
                    this.fireConfigActionEvent(new VWConfigActionEvent(this, this.m_focus, 32));
                    VWConfigBaseNode aNode = null;
                    int childCount = this.m_focus.getChildCount();
                    for (int i = 0; i < childCount; ++i) {
                        aNode = (VWConfigBaseNode)this.m_focus.getChildAt(i);
                        this.collapsePath(aNode);
                    }
                }
                this.m_scopeTree.refresh();
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_ROSTER_PROPERTIES) == 0) {
                this.m_performer.performRosterProperty(this.m_focus);
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_SYSTEM_PROPERTIES) == 0) {
                this.m_performer.performVWServiceProperties(this.m_focus);
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_VERIFY_XLIFF_FILE) == 0) {
                this.m_performer.performVerifyXliffFile(this.m_focus);
                this.m_scopeTree.requestFocus();
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_HELP) == 0) {
                this.m_performer.performHelp(this.m_focus);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void configActionPerformed(VWConfigActionEvent evt) {
        VWConfigBaseNode baseNode = evt.getBaseNode();
        try {
            if (evt.displayAllRegions()) {
                this.displayAllRegions();
                this.m_scopeTree.refresh();
            } else if (evt.refresh()) {
                this.m_scopeTree.refresh();
            }
            if (evt.changedFocus()) {
                this.setFocus(baseNode);
                this.expandScopeTree(this.m_focus);
            }
            if (evt.expandTree()) {
                this.expandScopeTree(this.m_focus);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void releaseResources() {
        if (this.m_scopeTree != null) {
            this.m_scopeTree.removeMouseListener(this.m_scopeTreeMouseAdapter);
            this.m_scopeTree.releaseResources();
            this.m_scopeTree.removeTreeSelectionListener(this);
            this.m_scopeTree.setSelectionPath(null);
            this.m_scopeTree.setCellRenderer(null);
            this.m_scopeTree.removeAll();
            this.m_scopeTree = null;
        }
        if (this.m_scopeTreeMouseAdapter != null) {
            this.m_scopeTreeMouseAdapter.releaseResources();
            this.m_scopeTreeMouseAdapter = null;
        }
        this.m_focus = null;
        if (this.m_listenerList != null) {
            Object[] listeners = this.m_listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                this.m_listenerList.remove(IVWConfigActionListener.class, (IVWConfigActionListener)listeners[i + 1]);
                listeners[i] = null;
                listeners[i + 1] = null;
            }
            this.m_listenerList = null;
        }
        this.m_performer = null;
        this.m_root = null;
        this.removeAll();
    }

    protected void fireConfigActionEvent(VWConfigActionEvent evt) {
        if (evt == null) {
            return;
        }
        Object[] listeners = this.m_listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != IVWConfigActionListener.class) continue;
            ((IVWConfigActionListener)listeners[i + 1]).configActionPerformed(evt);
        }
    }

    public void setFocus(VWConfigBaseNode focus) {
        this.m_focus = focus;
        this.m_scopeTree.setFocus(this.m_focus);
        this.m_scopeTreeMouseAdapter.setFocus(this.m_focus);
    }
}

